/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.AggregatedPickup;
import dev.obscuria.lootjournal.client.pickup.ExperiencePickup;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import dev.obscuria.lootjournal.client.pickup.ItemPickup;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

public final class PickupComponent {
    private static final HashMap<Integer, PickupInstance> occupied = Maps.newHashMap();
    private static final List<PickupInstance> displayed = Lists.newArrayList();
    private static final Deque<IPickupEntry> queued = Queues.newArrayDeque();

    public static void render(class_332 graphics) {
        class_1041 window = class_310.method_1551().method_22683();
        graphics.method_51448().method_22903();
        LootJournal.CONFIG.anchor.transform(graphics, window);
        displayed.removeIf(instance -> {
            if (!instance.render(graphics)) {
                return false;
            }
            occupied.remove(instance.index);
            return true;
        });
        graphics.method_51448().method_22909();
        if (queued.isEmpty() || PickupComponent.isAllSlotsOccupied()) {
            return;
        }
        queued.removeIf(pickup -> {
            int index = PickupComponent.findFreeSlot();
            if (index <= -1) {
                return false;
            }
            PickupInstance instance = new PickupInstance((IPickupEntry)pickup, index);
            displayed.add(instance);
            occupied.put(index, instance);
            return true;
        });
    }

    public static void appendItem(int itemId, int playerId, int amount) {
        if (!LootJournal.CONFIG.itemEntryDisplay) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_5628() != playerId) {
            return;
        }
        class_1297 class_12972 = player.method_37908().method_8469(itemId);
        if (!(class_12972 instanceof class_1542)) {
            return;
        }
        class_1542 entity = (class_1542)class_12972;
        class_1799 stack = entity.method_6983().method_7972();
        stack.method_7939(amount);
        PickupComponent.appendItem(stack);
    }

    public static void appendItem(class_1799 stack) {
        if (!LootJournal.CONFIG.itemEntryDisplay) {
            return;
        }
        if (!LootJournal.isAllowed(stack)) {
            return;
        }
        boolean shouldAggregate = PickupComponent.shouldAggregate();
        if (shouldAggregate && !LootJournal.CONFIG.aggregatedEntryDisplay) {
            return;
        }
        PickupComponent.append(shouldAggregate ? new AggregatedPickup(stack) : new ItemPickup(stack));
    }

    public static void appendExperience(int amount) {
        if (!LootJournal.CONFIG.experienceEntryDisplay) {
            return;
        }
        PickupComponent.append(new ExperiencePickup(amount));
    }

    private static void append(IPickupEntry pickup) {
        if (PickupComponent.maybeMerge(pickup)) {
            return;
        }
        int index = PickupComponent.findFreeSlot();
        if (index > -1) {
            PickupInstance instance = new PickupInstance(pickup, index);
            displayed.add(instance);
            occupied.put(index, instance);
        } else if (PickupComponent.shouldEnqueue(pickup)) {
            queued.add(pickup);
        }
    }

    private static boolean maybeMerge(IPickupEntry pickup) {
        for (PickupInstance instance : displayed) {
            if (!instance.maybeMerge(pickup)) continue;
            return true;
        }
        for (IPickupEntry other : queued) {
            if (!other.maybeMerge(pickup)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldEnqueue(IPickupEntry pickup) {
        return pickup instanceof AggregatedPickup || queued.size() < LootJournal.CONFIG.queueCapacity;
    }

    private static int findFreeSlot() {
        for (int i = 0; i < LootJournal.CONFIG.displayCapacity; ++i) {
            if (occupied.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isAllSlotsOccupied() {
        return displayed.size() >= LootJournal.CONFIG.displayCapacity;
    }

    private static boolean shouldAggregate() {
        return PickupComponent.isAllSlotsOccupied() && queued.size() >= LootJournal.CONFIG.queueCapacity - 1;
    }

    private static final class PickupInstance {
        private static final long FADE_IN = 750L;
        private static final long FADE_OUT = 1500L;
        private final IPickupEntry pickup;
        private long startTime = -1L;
        private long lastTime;
        private double progress;
        private double delta;
        public int index;

        public PickupInstance(IPickupEntry pickup, int index) {
            this.pickup = pickup;
            this.index = index;
        }

        public boolean render(class_332 graphics) {
            long currentTime = class_156.method_658();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
                this.lastTime = currentTime;
            }
            this.delta = (double)(currentTime - this.lastTime) / 1000.0;
            this.lastTime = currentTime;
            long time = currentTime - this.startTime;
            if (!class_310.method_1551().field_1690.field_1842) {
                int offset = LootJournal.CONFIG.anchor.getStep() * this.index;
                LootJournal.CONFIG.style.render(this.pickup, graphics, offset, this.progress, time);
            }
            this.updateProgress(time);
            return time > this.getDisplayTime();
        }

        public boolean maybeMerge(IPickupEntry other) {
            if (this.pickup.maybeMerge(other)) {
                this.startTime = class_156.method_658();
                return true;
            }
            return this.pickup.maybeMerge(other);
        }

        private void updateProgress(long time) {
            if (time <= 750L) {
                this.progress = Math.min(this.progress + this.delta * 2.0, 1.0);
            }
            if (time >= this.getDisplayTime() - 1500L) {
                this.progress = Math.max(this.progress - this.delta, 0.0);
            }
        }

        private long getLifetime() {
            return 1000L * (long)LootJournal.CONFIG.lifetime;
        }

        private long getDisplayTime() {
            return 2250L + this.getLifetime();
        }
    }
}

